﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Microsoft.Win32;

namespace TypyPlikow
{
    public partial class Form1 : Form
    {
        private SortedList<string,string> rozszerzenia = PobierzRozszerzeniaPlikow();

        public Form1()
        {
            InitializeComponent();

            //umieszczanie listy rozszerzeń w rozwijanej liście comboBox1
            comboBox1.Items.AddRange(rozszerzenia.Keys.ToArray());
            comboBox1.SelectedIndex = 0;
        }

        private static SortedList<string,string> PobierzRozszerzeniaPlikow()
        {
            RegistryKey rejestr = Registry.ClassesRoot;            
            SortedList<string,string> rozszerzenia = new SortedList<string,string>();
            foreach (string nazwa in rejestr.GetSubKeyNames())
                if (nazwa[0] == '.' && nazwa[1] != '_')
                {
                    try
                    {
                        string kod = rejestr.OpenSubKey(nazwa).GetValue("").ToString();
                        rozszerzenia.Add(nazwa, kod);
                    }
                    catch (NullReferenceException)
                    {
                        //brak opisu rozszerzenia
                    }
                }
            return rozszerzenia;
        }

        private void PobierzInformacjeOSkojarzonejAplikacji(string kod, out string opis, out string polecenie, out string edytor)
        {
            //otwieranie klucza HKEY_CLASSES_ROOT\[kod]
            RegistryKey rejestr = Registry.ClassesRoot.OpenSubKey(kod);
            if (rejestr == null)
            {
                throw new Exception("Klucz o wskazanej przez kod nazwie nie istnieje");
            }

            //odczytywanie opisu typu plikow
            try
            {
                opis = rejestr.GetValue("").ToString();
            }
            catch
            {
                //Brak wartosci domyslnej z opisem
                opis = "Brak opisu dla typu " + kod;
            }

            //odczytywanie nazwy polecenia głównego (domyślnie open)
            try
            {
                polecenie = rejestr.OpenSubKey("shell").GetValue("").ToString();
            }
            catch
            {
                //Polecenie domyślne nie jest zapisane
                polecenie = "open";
            }

            //odczytywanie nazwy pliku domyślnego edytora
            try
            {
                edytor = rejestr.OpenSubKey("shell").OpenSubKey(polecenie).OpenSubKey("command").GetValue("").ToString();
            }
            catch
            {
                throw new Exception("Brak informacji o domyślnym edytorze dla typu " + kod);
            }

            //zamykanie klucza
            rejestr.Close();
        }

        private bool PobierzInformacjeOSkojarzonejAplikacjiUzytkownika(string rozszerzenie, out string edytor)
        {
            //otwieranie klucza
            RegistryKey rejestr = Registry.CurrentUser.OpenSubKey("Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + rozszerzenie);
            edytor = "";
            if (rejestr == null) return false;

            //odczytywanie edytora
            try
            {
                edytor = rejestr.GetValue("Application").ToString();
            }
            catch
            {
                return false;
            }
            finally
            {
                //zamykanie klucza
                rejestr.Close();
            }
            
            return true;
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            string kod = "";
            if (!rozszerzenia.TryGetValue(comboBox1.SelectedItem.ToString(), out kod)) 
            {
                textBox1.Text = "";
                textBox2.Text = "";
                textBox3.Text = "";
                return;
            }
            textBox1.Text = kod;

            string opis = "", polecenie = "", edytor = "", edytorUzytkownika = "";
            try
            {
                PobierzInformacjeOSkojarzonejAplikacji(kod, out opis, out polecenie, out edytor);
                if (PobierzInformacjeOSkojarzonejAplikacjiUzytkownika(kod, out edytorUzytkownika))
                    edytor = edytorUzytkownika + " (prywatne)";
                textBox3.Text = edytor;
            }
            catch (Exception ex)
            {
                textBox3.Text = ex.Message;
            }
            textBox2.Text = opis;
        }
    }
}
